/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.planning.mokos.AbstractScorer;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.Processor;
import cz.insophy.inplan.util.Tuple;
import java.util.Set;

public abstract class AbstractPlanningScorer<T extends Comparable<T>>
extends AbstractScorer<T> {
    public AbstractPlanningScorer(String scoreProperty) {
        super(scoreProperty);
    }

    protected abstract T getPlanningScore(Operation var1, Operation.OperationPlanning var2);

    @Override
    public final Tuple<Processor, Set<Operation>> process(Set<Operation> ops) {
        for (Operation op : ops) {
            Preconditions.checkArgument(!op.getPlannings().isEmpty(), "All operations need to contain at least one planning in %s", (Object)this.getClass().getSimpleName());
            for (Operation.OperationPlanning planning : op.getPlannings()) {
                planning.setProperty(this.getScoreProperty(), this.getPlanningScore(op, planning));
            }
        }
        return Tuple.create(this.getDefaultSuccessor(), ops);
    }
}

